import{Room as e,RoomEvent as t,ConnectionState as n,Track as o,createLocalAudioTrack as a}from"livekit-client";function s(){return s=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var o in n)({}).hasOwnProperty.call(n,o)&&(e[o]=n[o])}return e},s.apply(null,arguments)}const i=new Uint8Array(0);class r{static getFullOptions(e){return s({clientTools:{},onConnect:()=>{},onDebug:()=>{},onDisconnect:()=>{},onError:()=>{},onMessage:()=>{},onAudio:()=>{},onModeChange:()=>{},onStatusChange:()=>{},onCanSendFeedbackChange:()=>{},onInterruption:()=>{}},e)}constructor(e,t){var n=this;this.options=void 0,this.connection=void 0,this.lastInterruptTimestamp=0,this.mode="listening",this.status="connecting",this.volume=1,this.currentEventId=1,this.lastFeedbackEventId=0,this.canSendFeedback=!1,this.endSessionWithDetails=async function(e){"connected"!==n.status&&"connecting"!==n.status||(n.updateStatus("disconnecting"),await n.handleEndSession(),n.updateStatus("disconnected"),n.options.onDisconnect&&n.options.onDisconnect(e))},this.onMessage=async function(e){switch(e.type){case"interruption":return void n.handleInterruption(e);case"agent_response":return void n.handleAgentResponse(e);case"user_transcript":return void n.handleUserTranscript(e);case"internal_tentative_agent_response":return void n.handleTentativeAgentResponse(e);case"client_tool_call":try{await n.handleClientToolCall(e)}catch(t){n.onError(`Unexpected error in client tool call handling: ${t instanceof Error?t.message:String(t)}`,{clientToolName:e.client_tool_call.tool_name,toolCallId:e.client_tool_call.tool_call_id})}return;case"audio":return void n.handleAudio(e);case"vad_score":return void n.handleVadScore(e);case"ping":return void n.connection.sendMessage({type:"pong",event_id:e.ping_event.event_id});case"mcp_tool_call":return void n.handleMCPToolCall(e);case"mcp_connection_status":return void n.handleMCPConnectionStatus(e);case"agent_tool_response":return void n.handleAgentToolResponse(e);case"conversation_initiation_metadata":return void n.handleConversationMetadata(e);case"asr_initiation_metadata":return void n.handleAsrInitiationMetadata(e);case"agent_chat_response_part":return void n.handleAgentChatResponsePart(e);case"error":return void n.handleErrorEvent(e);default:return void(n.options.onDebug&&n.options.onDebug(e))}},this.setVolume=({volume:e})=>{this.volume=e},this.options=e,this.connection=t,this.options.onConnect&&this.options.onConnect({conversationId:t.conversationId}),this.connection.onMessage(this.onMessage),this.connection.onDisconnect(this.endSessionWithDetails),this.connection.onModeChange(e=>this.updateMode(e)),this.updateStatus("connected")}endSession(){return this.endSessionWithDetails({reason:"user"})}async handleEndSession(){this.connection.close()}updateMode(e){e!==this.mode&&(this.mode=e,this.options.onModeChange&&this.options.onModeChange({mode:e}))}updateStatus(e){e!==this.status&&(this.status=e,this.options.onStatusChange&&this.options.onStatusChange({status:e}))}updateCanSendFeedback(){const e=this.currentEventId!==this.lastFeedbackEventId;this.canSendFeedback!==e&&(this.canSendFeedback=e,this.options.onCanSendFeedbackChange&&this.options.onCanSendFeedbackChange({canSendFeedback:e}))}handleInterruption(e){e.interruption_event&&(this.lastInterruptTimestamp=e.interruption_event.event_id,this.options.onInterruption&&this.options.onInterruption({event_id:e.interruption_event.event_id}))}handleAgentResponse(e){this.options.onMessage&&this.options.onMessage({source:"ai",message:e.agent_response_event.agent_response})}handleUserTranscript(e){this.options.onMessage&&this.options.onMessage({source:"user",message:e.user_transcription_event.user_transcript})}handleTentativeAgentResponse(e){this.options.onDebug&&this.options.onDebug({type:"tentative_agent_response",response:e.tentative_agent_response_internal_event.tentative_agent_response})}handleVadScore(e){this.options.onVadScore&&this.options.onVadScore({vadScore:e.vad_score_event.vad_score})}async handleClientToolCall(e){if(Object.prototype.hasOwnProperty.call(this.options.clientTools,e.client_tool_call.tool_name))try{var t;const n=null!=(t=await this.options.clientTools[e.client_tool_call.tool_name](e.client_tool_call.parameters))?t:"Client tool execution successful.",o="object"==typeof n?JSON.stringify(n):String(n);this.connection.sendMessage({type:"client_tool_result",tool_call_id:e.client_tool_call.tool_call_id,result:o,is_error:!1})}catch(t){this.onError(`Client tool execution failed with following error: ${null==t?void 0:t.message}`,{clientToolName:e.client_tool_call.tool_name}),this.connection.sendMessage({type:"client_tool_result",tool_call_id:e.client_tool_call.tool_call_id,result:`Client tool execution failed: ${null==t?void 0:t.message}`,is_error:!0})}else{if(this.options.onUnhandledClientToolCall)return void this.options.onUnhandledClientToolCall(e.client_tool_call);this.onError(`Client tool with name ${e.client_tool_call.tool_name} is not defined on client`,{clientToolName:e.client_tool_call.tool_name}),this.connection.sendMessage({type:"client_tool_result",tool_call_id:e.client_tool_call.tool_call_id,result:`Client tool with name ${e.client_tool_call.tool_name} is not defined on client`,is_error:!0})}}handleAudio(e){}handleMCPToolCall(e){this.options.onMCPToolCall&&this.options.onMCPToolCall(e.mcp_tool_call)}handleMCPConnectionStatus(e){this.options.onMCPConnectionStatus&&this.options.onMCPConnectionStatus(e.mcp_connection_status)}handleAgentToolResponse(e){"end_call"===e.agent_tool_response.tool_name&&this.endSessionWithDetails({reason:"agent",context:new CloseEvent("end_call",{reason:"Agent ended the call"})}),this.options.onAgentToolResponse&&this.options.onAgentToolResponse(e.agent_tool_response)}handleConversationMetadata(e){this.options.onConversationMetadata&&this.options.onConversationMetadata(e.conversation_initiation_metadata_event)}handleAsrInitiationMetadata(e){this.options.onAsrInitiationMetadata&&this.options.onAsrInitiationMetadata(e.asr_initiation_metadata_event)}handleAgentChatResponsePart(e){this.options.onAgentChatResponsePart&&this.options.onAgentChatResponsePart(e.text_response_part)}handleErrorEvent(e){const t=e.error_event.error_type,n=e.error_event.message||e.error_event.reason||"Unknown error";"max_duration_exceeded"!==t?this.onError(`Server error: ${n}`,{errorType:t,code:e.error_event.code,debugMessage:e.error_event.debug_message,details:e.error_event.details}):this.endSessionWithDetails({reason:"error",message:n,context:new Event("max_duration_exceeded")})}onError(e,t){console.error(e,t),this.options.onError&&this.options.onError(e,t)}getId(){return this.connection.conversationId}isOpen(){return"connected"===this.status}setMicMuted(e){this.connection.setMicMuted(e)}getInputByteFrequencyData(){return i}getOutputByteFrequencyData(){return i}getInputVolume(){return 0}getOutputVolume(){return 0}sendFeedback(e){this.canSendFeedback?(this.connection.sendMessage({type:"feedback",score:e?"like":"dislike",event_id:this.currentEventId}),this.lastFeedbackEventId=this.currentEventId,this.updateCanSendFeedback()):console.warn(0===this.lastFeedbackEventId?"Cannot send feedback: the conversation has not started yet.":"Cannot send feedback: feedback has already been sent for the current response.")}sendContextualUpdate(e){this.connection.sendMessage({type:"contextual_update",text:e})}sendUserMessage(e){this.connection.sendMessage({type:"user_message",text:e})}sendUserActivity(){this.connection.sendMessage({type:"user_activity"})}sendMCPToolApprovalResult(e,t){this.connection.sendMessage({type:"mcp_tool_approval_result",tool_call_id:e,is_approved:t})}}class c{constructor(e={}){this.queue=[],this.disconnectionDetails=null,this.onDisconnectCallback=null,this.onMessageCallback=null,this.onModeChangeCallback=null,this.onDebug=void 0,this.onDebug=e.onDebug}debug(e){this.onDebug&&this.onDebug(e)}onMessage(e){this.onMessageCallback=e;const t=this.queue;this.queue=[],t.length>0&&queueMicrotask(()=>{t.forEach(e)})}onDisconnect(e){this.onDisconnectCallback=e;const t=this.disconnectionDetails;t&&queueMicrotask(()=>{e(t)})}onModeChange(e){this.onModeChangeCallback=e}updateMode(e){var t;null==(t=this.onModeChangeCallback)||t.call(this,e)}disconnect(e){var t;this.disconnectionDetails||(this.disconnectionDetails=e,null==(t=this.onDisconnectCallback)||t.call(this,e))}handleMessage(e){this.onMessageCallback?this.onMessageCallback(e):this.queue.push(e)}}function l(e){const[t,n]=e.split("_");if(!["pcm","ulaw"].includes(t))throw new Error(`Invalid format: ${e}`);const o=Number.parseInt(n);if(Number.isNaN(o))throw new Error(`Invalid sample rate: ${n}`);return{format:t,sampleRate:o}}const u="0.10.0";function d(e){return!!e.type}const h="conversation_initiation_client_data";function p(e){var t;const n={type:h};var o,a,s,i,r;return e.overrides&&(n.conversation_config_override={agent:{prompt:null==(o=e.overrides.agent)?void 0:o.prompt,first_message:null==(a=e.overrides.agent)?void 0:a.firstMessage,language:null==(s=e.overrides.agent)?void 0:s.language},tts:{voice_id:null==(i=e.overrides.tts)?void 0:i.voiceId},conversation:{text_only:null==(r=e.overrides.conversation)?void 0:r.textOnly}}),e.customLlmExtraBody&&(n.custom_llm_extra_body=e.customLlmExtraBody),e.dynamicVariables&&(n.dynamic_variables=e.dynamicVariables),e.userId&&(n.user_id=e.userId),null!=(t=e.overrides)&&t.client&&(n.source_info={source:e.overrides.client.source,version:e.overrides.client.version}),n}class m extends c{constructor(e,t,n,o){super(),this.socket=void 0,this.conversationId=void 0,this.inputFormat=void 0,this.outputFormat=void 0,this.socket=e,this.conversationId=t,this.inputFormat=n,this.outputFormat=o,this.socket.addEventListener("error",e=>{setTimeout(()=>this.disconnect({reason:"error",message:"The connection was closed due to a socket error.",context:e}),0)}),this.socket.addEventListener("close",e=>{this.disconnect(1e3===e.code?{reason:"agent",context:e}:{reason:"error",message:e.reason||"The connection was closed by the server.",context:e})}),this.socket.addEventListener("message",e=>{try{const t=JSON.parse(e.data);if(!d(t))return void this.debug({type:"invalid_event",message:"Received invalid socket event",data:e.data});this.handleMessage(t)}catch(t){this.debug({type:"parsing_error",message:"Failed to parse socket message",error:t instanceof Error?t.message:String(t),data:e.data})}})}static async create(e){let t=null;try{var n,o,a;const s=null!=(n=e.origin)?n:"wss://api.elevenlabs.io";let i;const r=(null==(o=e.overrides)||null==(o=o.client)?void 0:o.version)||u,c=(null==(a=e.overrides)||null==(a=a.client)?void 0:a.source)||"js_sdk";if(e.signedUrl){const t=e.signedUrl.includes("?")?"&":"?";i=`${e.signedUrl}${t}source=${c}&version=${r}`}else i=`${s}/v1/convai/conversation?agent_id=${e.agentId}&source=${c}&version=${r}`;const h=["convai"];e.authorization&&h.push(`bearer.${e.authorization}`),t=new WebSocket(i,h);const v=await new Promise((n,o)=>{t.addEventListener("open",()=>{var n;const o=p(e);null==(n=t)||n.send(JSON.stringify(o))},{once:!0}),t.addEventListener("error",e=>{setTimeout(()=>o(e),0)}),t.addEventListener("close",o),t.addEventListener("message",e=>{const t=JSON.parse(e.data);d(t)&&("conversation_initiation_metadata"===t.type?n(t.conversation_initiation_metadata_event):console.warn("First received message is not conversation metadata."))},{once:!0})}),{conversation_id:g,agent_output_audio_format:f,user_input_audio_format:w}=v,_=l(null!=w?w:"pcm_16000"),y=l(f);return new m(t,g,_,y)}catch(e){var s;throw null==(s=t)||s.close(),e}}close(){this.socket.close()}sendMessage(e){this.socket.send(JSON.stringify(e))}async setMicMuted(e){console.warn(`WebSocket connection setMicMuted called with ${e}, but this is handled by VoiceConversation`)}}function v(e){const t=new Uint8Array(e);return window.btoa(String.fromCharCode(...t))}function g(e){const t=window.atob(e),n=t.length,o=new Uint8Array(n);for(let e=0;e<n;e++)o[e]=t.charCodeAt(e);return o.buffer}const f=new Map;function w(e,t){return async(n,o)=>{const a=f.get(e);if(a)return n.addModule(a);if(o)try{return await n.addModule(o),void f.set(e,o)}catch(t){throw new Error(`Failed to load the ${e} worklet module from path: ${o}. Error: ${t}`)}const s=new Blob([t],{type:"application/javascript"}),i=URL.createObjectURL(s);try{return await n.addModule(i),void f.set(e,i)}catch(e){URL.revokeObjectURL(i)}try{const o=`data:application/javascript;base64,${btoa(t)}`;await n.addModule(o),f.set(e,o)}catch(t){throw new Error(`Failed to load the ${e} worklet module. Make sure the browser supports AudioWorklets. If you are using a strict CSP, you may need to self-host the worklet files.`)}}}const _=w("rawAudioProcessor",'/*\n * ulaw encoding logic taken from the wavefile library\n * https://github.com/rochars/wavefile/blob/master/lib/codecs/mulaw.js\n * USED BY @elevenlabs/client\n */\n\nconst BIAS = 0x84;\nconst CLIP = 32635;\nconst encodeTable = [\n  0,0,1,1,2,2,2,2,3,3,3,3,3,3,3,3,\n  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,\n  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,\n  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,\n  6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,\n  6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,\n  6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,\n  6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,\n  7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,\n  7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,\n  7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,\n  7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,\n  7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,\n  7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,\n  7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,\n  7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7\n];\n\nfunction encodeSample(sample) {\n  let sign;\n  let exponent;\n  let mantissa;\n  let muLawSample;\n  sign = (sample >> 8) & 0x80;\n  if (sign !== 0) sample = -sample;\n  sample = sample + BIAS;\n  if (sample > CLIP) sample = CLIP;\n  exponent = encodeTable[(sample>>7) & 0xFF];\n  mantissa = (sample >> (exponent+3)) & 0x0F;\n  muLawSample = ~(sign | (exponent << 4) | mantissa);\n  \n  return muLawSample;\n}\n\nclass RawAudioProcessor extends AudioWorkletProcessor {\n  constructor() {\n    super();\n              \n    this.port.onmessage = ({ data }) => {\n      switch (data.type) {\n        case "setFormat":\n          this.isMuted = false;\n          this.buffer = []; // Initialize an empty buffer\n          this.bufferSize = data.sampleRate / 4;\n          this.format = data.format;\n\n          if (globalThis.LibSampleRate && sampleRate !== data.sampleRate) {\n            globalThis.LibSampleRate.create(1, sampleRate, data.sampleRate).then(resampler => {\n              this.resampler = resampler;\n            });\n          }\n          break;\n        case "setMuted":\n          this.isMuted = data.isMuted;\n          break;\n      }\n    };\n  }\n  process(inputs) {\n    if (!this.buffer) {\n      return true;\n    }\n    \n    const input = inputs[0]; // Get the first input node\n    if (input.length > 0) {\n      let channelData = input[0]; // Get the first channel\'s data\n\n      // Resample the audio if necessary\n      if (this.resampler) {\n        channelData = this.resampler.full(channelData);\n      }\n\n      // Add channel data to the buffer\n      this.buffer.push(...channelData);\n      // Get max volume \n      let sum = 0.0;\n      for (let i = 0; i < channelData.length; i++) {\n        sum += channelData[i] * channelData[i];\n      }\n      const maxVolume = Math.sqrt(sum / channelData.length);\n      // Check if buffer size has reached or exceeded the threshold\n      if (this.buffer.length >= this.bufferSize) {\n        const float32Array = this.isMuted \n          ? new Float32Array(this.buffer.length)\n          : new Float32Array(this.buffer);\n\n        let encodedArray = this.format === "ulaw"\n          ? new Uint8Array(float32Array.length)\n          : new Int16Array(float32Array.length);\n\n        // Iterate through the Float32Array and convert each sample to PCM16\n        for (let i = 0; i < float32Array.length; i++) {\n          // Clamp the value to the range [-1, 1]\n          let sample = Math.max(-1, Math.min(1, float32Array[i]));\n\n          // Scale the sample to the range [-32768, 32767]\n          let value = sample < 0 ? sample * 32768 : sample * 32767;\n          if (this.format === "ulaw") {\n            value = encodeSample(Math.round(value));\n          }\n\n          encodedArray[i] = value;\n        }\n\n        // Send the buffered data to the main script\n        this.port.postMessage([encodedArray, maxVolume]);\n\n        // Clear the buffer after sending\n        this.buffer = [];\n      }\n    }\n    return true; // Continue processing\n  }\n}\nregisterProcessor("rawAudioProcessor", RawAudioProcessor);\n');class y extends c{constructor(e,t,n,o,a={}){super(a),this.conversationId=void 0,this.inputFormat=void 0,this.outputFormat=void 0,this.room=void 0,this.isConnected=!1,this.audioEventId=1,this.audioCaptureContext=null,this.audioElements=[],this.outputDeviceId=null,this.outputAnalyser=null,this.outputFrequencyData=null,this.room=e,this.conversationId=t,this.inputFormat=n,this.outputFormat=o,this.setupRoomEventListeners()}static async create(n){let o;if("conversationToken"in n&&n.conversationToken)o=n.conversationToken;else{if(!("agentId"in n)||!n.agentId)throw new Error("Either conversationToken or agentId is required for WebRTC connection");try{var a,s,i;const e=(null==(a=n.overrides)||null==(a=a.client)?void 0:a.version)||u,t=(null==(s=n.overrides)||null==(s=s.client)?void 0:s.source)||"js_sdk",c=`${r=null!=(i=n.origin)?i:"https://api.elevenlabs.io",r.replace(/^wss:\/\//,"https://")}/v1/convai/conversation/token?agent_id=${n.agentId}&source=${t}&version=${e}`,l=await fetch(c);if(!l.ok)throw new Error(`ElevenLabs API returned ${l.status} ${l.statusText}`);if(o=(await l.json()).token,!o)throw new Error("No conversation token received from API")}catch(e){let t=e instanceof Error?e.message:String(e);throw e instanceof Error&&e.message.includes("401")&&(t="Your agent has authentication enabled, but no signed URL or conversation token was provided."),new Error(`Failed to fetch conversation token for agent ${n.agentId}: ${t}`)}}var r;const c=new e;try{const e=`room_${Date.now()}`,a=l("pcm_48000"),s=l("pcm_48000"),i=new y(c,e,a,s,n),r=n.livekitUrl||"wss://livekit.rtc.elevenlabs.io";var d;await c.connect(r,o),await new Promise(e=>{if(i.isConnected)e();else{const n=()=>{c.off(t.Connected,n),e()};c.on(t.Connected,n)}}),c.name&&(i.conversationId=(null==(d=c.name.match(/(conv_[a-zA-Z0-9]+)/))?void 0:d[0])||c.name),await c.localParticipant.setMicrophoneEnabled(!0);const u=p(n);return i.debug({type:h,message:u}),await i.sendMessage(u),i}catch(e){throw await c.disconnect(),e}}setupRoomEventListeners(){var e=this;this.room.on(t.Connected,async function(){e.isConnected=!0,console.info("WebRTC room connected")}),this.room.on(t.Disconnected,e=>{this.isConnected=!1,this.disconnect({reason:"agent",context:new CloseEvent("close",{reason:null==e?void 0:e.toString()})})}),this.room.on(t.ConnectionStateChanged,e=>{e===n.Disconnected&&(this.isConnected=!1,this.disconnect({reason:"error",message:`LiveKit connection state changed to ${e}`,context:new Event("connection_state_changed")}))}),this.room.on(t.DataReceived,(e,t)=>{try{const t=JSON.parse((new TextDecoder).decode(e));if("audio"===t.type)return;d(t)?this.handleMessage(t):console.warn("Invalid socket event received:",t)}catch(t){console.warn("Failed to parse incoming data message:",t),console.warn("Raw payload:",(new TextDecoder).decode(e))}}),this.room.on(t.TrackSubscribed,async function(t,n,a){if(t.kind===o.Kind.Audio&&a.identity.includes("agent")){const n=t,o=n.attach();if(o.autoplay=!0,o.controls=!1,e.outputDeviceId&&o.setSinkId)try{await o.setSinkId(e.outputDeviceId)}catch(e){console.warn("Failed to set output device for new audio element:",e)}o.style.display="none",document.body.appendChild(o),e.audioElements.push(o),1===e.audioElements.length&&(null==e.onDebug||e.onDebug({type:"audio_element_ready"})),await e.setupAudioCapture(n)}}),this.room.on(t.ActiveSpeakersChanged,async function(t){e.updateMode(t.length>0&&t[0].identity.startsWith("agent")?"speaking":"listening")})}close(){if(this.isConnected){try{this.room.localParticipant.audioTrackPublications.forEach(e=>{e.track&&e.track.stop()})}catch(e){console.warn("Error stopping local tracks:",e)}this.audioCaptureContext&&(this.audioCaptureContext.close().catch(e=>{console.warn("Error closing audio capture context:",e)}),this.audioCaptureContext=null),this.audioElements.forEach(e=>{e.parentNode&&e.parentNode.removeChild(e)}),this.audioElements=[],this.room.disconnect()}}async sendMessage(e){if(this.isConnected&&this.room.localParticipant){if(!("user_audio_chunk"in e))try{const t=(new TextEncoder).encode(JSON.stringify(e));await this.room.localParticipant.publishData(t,{reliable:!0})}catch(t){this.debug({type:"send_message_error",message:{message:e,error:t}}),console.error("Failed to send message via WebRTC:",t)}}else console.warn("Cannot send message: room not connected or no local participant")}getRoom(){return this.room}async setMicMuted(e){if(!this.isConnected||!this.room.localParticipant)return void console.warn("Cannot set microphone muted: room not connected or no local participant");const t=this.room.localParticipant.getTrackPublication(o.Source.Microphone);if(null!=t&&t.track)try{e?await t.track.mute():await t.track.unmute()}catch(t){await this.room.localParticipant.setMicrophoneEnabled(!e)}else await this.room.localParticipant.setMicrophoneEnabled(!e)}async setupAudioCapture(e){try{const t=new AudioContext;this.audioCaptureContext=t,this.outputAnalyser=t.createAnalyser(),this.outputAnalyser.fftSize=2048,this.outputAnalyser.smoothingTimeConstant=.8;const n=new MediaStream([e.mediaStreamTrack]),o=t.createMediaStreamSource(n);o.connect(this.outputAnalyser),await _(t.audioWorklet);const a=new AudioWorkletNode(t,"rawAudioProcessor");this.outputAnalyser.connect(a),a.port.postMessage({type:"setFormat",format:this.outputFormat.format,sampleRate:this.outputFormat.sampleRate}),a.port.onmessage=e=>{const[t,n]=e.data;if(n>.01){const e=v(t.buffer),n=this.audioEventId++;this.handleMessage({type:"audio",audio_event:{audio_base_64:e,event_id:n}})}},o.connect(a)}catch(e){console.warn("Failed to set up audio capture:",e)}}setAudioVolume(e){this.audioElements.forEach(t=>{t.volume=e})}async setAudioOutputDevice(e){if(!("setSinkId"in HTMLAudioElement.prototype))throw new Error("setSinkId is not supported in this browser");const t=this.audioElements.map(async function(t){try{await t.setSinkId(e)}catch(e){throw console.error("Failed to set sink ID for audio element:",e),e}});await Promise.all(t),this.outputDeviceId=e}async setAudioInputDevice(e){if(!this.isConnected||!this.room.localParticipant)throw new Error("Cannot change input device: room not connected or no local participant");try{const t=this.room.localParticipant.getTrackPublication(o.Source.Microphone);null!=t&&t.track&&(await t.track.stop(),await this.room.localParticipant.unpublishTrack(t.track));const n={deviceId:{exact:e},echoCancellation:!0,noiseSuppression:!0,autoGainControl:!0,channelCount:{ideal:1}},s=await a(n);await this.room.localParticipant.publishTrack(s,{name:"microphone",source:o.Source.Microphone})}catch(e){console.error("Failed to change input device:",e);try{await this.room.localParticipant.setMicrophoneEnabled(!0)}catch(e){console.error("Failed to recover microphone after device switch error:",e)}throw e}}getOutputByteFrequencyData(){return this.outputAnalyser?(null!=this.outputFrequencyData||(this.outputFrequencyData=new Uint8Array(this.outputAnalyser.frequencyBinCount)),this.outputAnalyser.getByteFrequencyData(this.outputFrequencyData),this.outputFrequencyData):null}}async function b(e){const t=function(e){return e.connectionType?e.connectionType:"conversationToken"in e&&e.conversationToken?"webrtc":"websocket"}(e);switch(t){case"websocket":return m.create(e);case"webrtc":return y.create(e);default:throw new Error(`Unknown connection type: ${t}`)}}function S(){return["iPad Simulator","iPhone Simulator","iPod Simulator","iPad","iPhone","iPod"].includes(navigator.platform)||navigator.userAgent.includes("Mac")&&"ontouchend"in document}async function k(e={default:0,android:3e3}){let t=e.default;var n;if(/android/i.test(navigator.userAgent))t=null!=(n=e.android)?n:t;else if(S()){var o;t=null!=(o=e.ios)?o:t}t>0&&await new Promise(e=>setTimeout(e,t))}class C extends r{static async startSession(e){const t=r.getFullOptions(e);t.onStatusChange&&t.onStatusChange({status:"connecting"}),t.onCanSendFeedbackChange&&t.onCanSendFeedbackChange({canSendFeedback:!1}),t.onModeChange&&t.onModeChange({mode:"listening"}),t.onCanSendFeedbackChange&&t.onCanSendFeedbackChange({canSendFeedback:!1});let n=null;try{return await k(t.connectionDelay),n=await b(e),new C(t,n)}catch(e){var o;throw t.onStatusChange&&t.onStatusChange({status:"disconnected"}),null==(o=n)||o.close(),e}}}const M={echoCancellation:!0,noiseSuppression:!0,autoGainControl:!0,channelCount:{ideal:1}};class E{static async create({sampleRate:e,format:t,preferHeadphonesForIosDevices:n,inputDeviceId:o,workletPaths:a,libsampleratePath:i}){let r=null,c=null;try{const l=s({sampleRate:{ideal:e}},M);if(S()&&n){const e=(await window.navigator.mediaDevices.enumerateDevices()).find(e=>"audioinput"===e.kind&&["airpod","headphone","earphone"].find(t=>e.label.toLowerCase().includes(t)));e&&(l.deviceId={ideal:e.deviceId})}o&&(l.deviceId={exact:o});const u=navigator.mediaDevices.getSupportedConstraints().sampleRate;r=new window.AudioContext(u?{sampleRate:e}:{});const d=r.createAnalyser();if(!u){const e=i||"https://cdn.jsdelivr.net/npm/@alexanderolsen/libsamplerate-js@2.1.2/dist/libsamplerate.worklet.js";await r.audioWorklet.addModule(e)}await _(r.audioWorklet,null==a?void 0:a.rawAudioProcessor);const h=s({voiceIsolation:!0},l);c=await navigator.mediaDevices.getUserMedia({audio:h});const p=r.createMediaStreamSource(c),m=new AudioWorkletNode(r,"rawAudioProcessor");return m.port.postMessage({type:"setFormat",format:t,sampleRate:e}),p.connect(d),d.connect(m),await r.resume(),new E(r,d,m,c,p)}catch(e){var l,u;throw null==(l=c)||l.getTracks().forEach(e=>{e.stop()}),null==(u=r)||u.close(),e}}constructor(e,t,n,o,a){this.context=void 0,this.analyser=void 0,this.worklet=void 0,this.inputStream=void 0,this.mediaStreamSource=void 0,this.context=e,this.analyser=t,this.worklet=n,this.inputStream=o,this.mediaStreamSource=a}async close(){this.inputStream.getTracks().forEach(e=>{e.stop()}),this.mediaStreamSource.disconnect(),await this.context.close()}setMuted(e){this.worklet.port.postMessage({type:"setMuted",isMuted:e})}async setInputDevice(e){try{const t=s({},M);e&&(t.deviceId={exact:e});const n=s({voiceIsolation:!0},t),o=await navigator.mediaDevices.getUserMedia({audio:n});this.inputStream.getTracks().forEach(e=>{e.stop()}),this.mediaStreamSource.disconnect(),this.inputStream=o,this.mediaStreamSource=this.context.createMediaStreamSource(o),this.mediaStreamSource.connect(this.analyser)}catch(e){throw console.error("Failed to switch input device:",e),e}}}const A=w("audioConcatProcessor",'/*\n * ulaw decoding logic taken from the wavefile library\n * https://github.com/rochars/wavefile/blob/master/lib/codecs/mulaw.js\n * USED BY @elevenlabs/client\n */\n\nconst decodeTable = [0,132,396,924,1980,4092,8316,16764];\n\nfunction decodeSample(muLawSample) {\n  let sign;\n  let exponent;\n  let mantissa;\n  let sample;\n  muLawSample = ~muLawSample;\n  sign = (muLawSample & 0x80);\n  exponent = (muLawSample >> 4) & 0x07;\n  mantissa = muLawSample & 0x0F;\n  sample = decodeTable[exponent] + (mantissa << (exponent+3));\n  if (sign !== 0) sample = -sample;\n\n  return sample;\n}\n\nclass AudioConcatProcessor extends AudioWorkletProcessor {\n  constructor() {\n    super();\n    this.buffers = []; // Initialize an empty buffer\n    this.cursor = 0;\n    this.currentBuffer = null;\n    this.wasInterrupted = false;\n    this.finished = false;\n    \n    this.port.onmessage = ({ data }) => {\n      switch (data.type) {\n        case "setFormat":\n          this.format = data.format;\n          break;\n        case "buffer":\n          this.wasInterrupted = false;\n          this.buffers.push(\n            this.format === "ulaw"\n              ? new Uint8Array(data.buffer)\n              : new Int16Array(data.buffer)\n          );\n          break;\n        case "interrupt":\n          this.wasInterrupted = true;\n          break;\n        case "clearInterrupted":\n          if (this.wasInterrupted) {\n            this.wasInterrupted = false;\n            this.buffers = [];\n            this.currentBuffer = null;\n          }\n      }\n    };\n  }\n  process(_, outputs) {\n    let finished = false;\n    const output = outputs[0][0];\n    for (let i = 0; i < output.length; i++) {\n      if (!this.currentBuffer) {\n        if (this.buffers.length === 0) {\n          finished = true;\n          break;\n        }\n        this.currentBuffer = this.buffers.shift();\n        this.cursor = 0;\n      }\n\n      let value = this.currentBuffer[this.cursor];\n      if (this.format === "ulaw") {\n        value = decodeSample(value);\n      }\n      output[i] = value / 32768;\n      this.cursor++;\n\n      if (this.cursor >= this.currentBuffer.length) {\n        this.currentBuffer = null;\n      }\n    }\n\n    if (this.finished !== finished) {\n      this.finished = finished;\n      this.port.postMessage({ type: "process", finished });\n    }\n\n    return true; // Continue processing\n  }\n}\n\nregisterProcessor("audioConcatProcessor", AudioConcatProcessor);\n');class I{static async create({sampleRate:e,format:t,outputDeviceId:n,workletPaths:o}){let a=null,s=null;try{a=new AudioContext({sampleRate:e});const i=a.createAnalyser(),r=a.createGain();s=new Audio,s.src="",s.load(),s.autoplay=!0,s.style.display="none",document.body.appendChild(s);const c=a.createMediaStreamDestination();s.srcObject=c.stream,r.connect(i),i.connect(c),await A(a.audioWorklet,null==o?void 0:o.audioConcatProcessor);const l=new AudioWorkletNode(a,"audioConcatProcessor");return l.port.postMessage({type:"setFormat",format:t}),l.connect(r),await a.resume(),n&&s.setSinkId&&await s.setSinkId(n),new I(a,i,r,l,s)}catch(e){var i,r;throw null!=(i=s)&&i.parentNode&&s.parentNode.removeChild(s),null==(r=s)||r.pause(),a&&"closed"!==a.state&&await a.close(),e}}constructor(e,t,n,o,a){this.context=void 0,this.analyser=void 0,this.gain=void 0,this.worklet=void 0,this.audioElement=void 0,this.context=e,this.analyser=t,this.gain=n,this.worklet=o,this.audioElement=a}async setOutputDevice(e){if(!("setSinkId"in HTMLAudioElement.prototype))throw new Error("setSinkId is not supported in this browser");await this.audioElement.setSinkId(e||"")}async close(){this.audioElement.parentNode&&this.audioElement.parentNode.removeChild(this.audioElement),this.audioElement.pause(),await this.context.close()}}class D extends r{static async startSession(e){var t;const n=r.getFullOptions(e);n.onStatusChange&&n.onStatusChange({status:"connecting"}),n.onCanSendFeedbackChange&&n.onCanSendFeedbackChange({canSendFeedback:!1});let o=null,a=null,i=null,c=null,l=null;if(null==(t=e.useWakeLock)||t)try{l=await navigator.wakeLock.request("screen")}catch(e){}try{var u;return c=await navigator.mediaDevices.getUserMedia({audio:!0}),await k(n.connectionDelay),a=await b(e),[o,i]=await Promise.all([E.create(s({},a.inputFormat,{preferHeadphonesForIosDevices:e.preferHeadphonesForIosDevices,inputDeviceId:e.inputDeviceId,workletPaths:e.workletPaths,libsampleratePath:e.libsampleratePath})),I.create(s({},a.outputFormat,{outputDeviceId:e.outputDeviceId,workletPaths:e.workletPaths}))]),null==(u=c)||u.getTracks().forEach(e=>{e.stop()}),c=null,new D(n,a,o,i,l)}catch(e){var d,h,p,m;n.onStatusChange&&n.onStatusChange({status:"disconnected"}),null==(d=c)||d.getTracks().forEach(e=>{e.stop()}),null==(h=a)||h.close(),await(null==(p=o)?void 0:p.close()),await(null==(m=i)?void 0:m.close());try{var v;await(null==(v=l)?void 0:v.release()),l=null}catch(e){}throw e}}constructor(e,t,n,o,a){super(e,t),this.input=void 0,this.output=void 0,this.wakeLock=void 0,this.inputFrequencyData=void 0,this.outputFrequencyData=void 0,this.onInputWorkletMessage=e=>{"connected"===this.status&&this.connection.sendMessage({user_audio_chunk:v(e.data[0].buffer)})},this.onOutputWorkletMessage=({data:e})=>{"process"===e.type&&this.updateMode(e.finished?"listening":"speaking")},this.addAudioBase64Chunk=e=>{this.output.gain.gain.cancelScheduledValues(this.output.context.currentTime),this.output.gain.gain.value=this.volume,this.output.worklet.port.postMessage({type:"clearInterrupted"}),this.output.worklet.port.postMessage({type:"buffer",buffer:g(e)})},this.fadeOutAudio=()=>{this.updateMode("listening"),this.output.worklet.port.postMessage({type:"interrupt"}),this.output.gain.gain.exponentialRampToValueAtTime(1e-4,this.output.context.currentTime+2),setTimeout(()=>{this.output.gain.gain.value=this.volume,this.output.worklet.port.postMessage({type:"clearInterrupted"})},2e3)},this.calculateVolume=e=>{if(0===e.length)return 0;let t=0;for(let n=0;n<e.length;n++)t+=e[n]/255;return t/=e.length,t<0?0:t>1?1:t},this.setVolume=({volume:e})=>{const t=Number.isFinite(e)?Math.min(1,Math.max(0,e)):1;this.volume=t,this.connection instanceof y?this.connection.setAudioVolume(t):this.output.gain.gain.value=t},this.input=n,this.output=o,this.wakeLock=a,this.input.worklet.port.onmessage=this.onInputWorkletMessage,this.output.worklet.port.onmessage=this.onOutputWorkletMessage}async handleEndSession(){await super.handleEndSession();try{var e;await(null==(e=this.wakeLock)?void 0:e.release()),this.wakeLock=null}catch(e){}await this.input.close(),await this.output.close()}handleInterruption(e){super.handleInterruption(e),this.fadeOutAudio()}handleAudio(e){var t,n;this.lastInterruptTimestamp<=e.audio_event.event_id&&(null==(t=(n=this.options).onAudio)||t.call(n,e.audio_event.audio_base_64),this.connection instanceof y||this.addAudioBase64Chunk(e.audio_event.audio_base_64),this.currentEventId=e.audio_event.event_id,this.updateCanSendFeedback(),this.updateMode("speaking"))}setMicMuted(e){this.connection instanceof y?this.connection.setMicMuted(e):this.input.setMuted(e)}getInputByteFrequencyData(){return null!=this.inputFrequencyData||(this.inputFrequencyData=new Uint8Array(this.input.analyser.frequencyBinCount)),this.input.analyser.getByteFrequencyData(this.inputFrequencyData),this.inputFrequencyData}getOutputByteFrequencyData(){return this.connection instanceof y?this.connection.getOutputByteFrequencyData()||new Uint8Array(1024):(null!=this.outputFrequencyData||(this.outputFrequencyData=new Uint8Array(this.output.analyser.frequencyBinCount)),this.output.analyser.getByteFrequencyData(this.outputFrequencyData),this.outputFrequencyData)}getInputVolume(){return this.calculateVolume(this.getInputByteFrequencyData())}getOutputVolume(){return this.calculateVolume(this.getOutputByteFrequencyData())}async changeInputDevice({sampleRate:e,format:t,preferHeadphonesForIosDevices:n,inputDeviceId:o}){try{if(this.connection instanceof m)try{return await this.input.setInputDevice(o),this.input}catch(e){console.warn("Failed to change device on existing input, recreating:",e)}this.connection instanceof y&&await this.connection.setAudioInputDevice(o||""),await this.input.close();const a=await E.create({sampleRate:null!=e?e:this.connection.inputFormat.sampleRate,format:null!=t?t:this.connection.inputFormat.format,preferHeadphonesForIosDevices:n,inputDeviceId:o,workletPaths:this.options.workletPaths,libsampleratePath:this.options.libsampleratePath});return this.input=a,this.input.worklet.port.onmessage=this.onInputWorkletMessage,this.input}catch(e){throw console.error("Error changing input device",e),e}}async changeOutputDevice({sampleRate:e,format:t,outputDeviceId:n}){try{if(this.connection instanceof m)try{return await this.output.setOutputDevice(n),this.output}catch(e){console.warn("Failed to change device on existing output, recreating:",e)}this.connection instanceof y&&await this.connection.setAudioOutputDevice(n||""),await this.output.close();const o=await I.create({sampleRate:null!=e?e:this.connection.outputFormat.sampleRate,format:null!=t?t:this.connection.outputFormat.format,outputDeviceId:n,workletPaths:this.options.workletPaths});return this.output=o,this.output}catch(e){throw console.error("Error changing output device",e),e}}}function T(e,t,n="https://api.elevenlabs.io"){const o={};return"boolean"==typeof t?o.feedback=t?"like":"dislike":(o.rating=t.rating,o.comment=t.comment),fetch(`${n}/v1/convai/conversations/${e}/feedback`,{method:"POST",body:JSON.stringify(o),headers:{"Content-Type":"application/json"}})}class P{constructor(){this.listeners=new Map}on(e,t){this.listeners.has(e)||this.listeners.set(e,new Set);const n=this.listeners.get(e);n&&n.add(t)}off(e,t){const n=this.listeners.get(e);n&&n.delete(t)}emit(e,...t){const n=this.listeners.get(e);n&&n.forEach(e=>{e(...t)})}}var F;!function(e){e.SESSION_STARTED="session_started",e.PARTIAL_TRANSCRIPT="partial_transcript",e.COMMITTED_TRANSCRIPT="committed_transcript",e.COMMITTED_TRANSCRIPT_WITH_TIMESTAMPS="committed_transcript_with_timestamps",e.AUTH_ERROR="auth_error",e.ERROR="error",e.OPEN="open",e.CLOSE="close"}(F||(F={}));class R{constructor(e){this.websocket=null,this.eventEmitter=new P,this.currentSampleRate=16e3,this._audioCleanup=void 0,this.currentSampleRate=e}setWebSocket(e){this.websocket=e,this.websocket.readyState===WebSocket.OPEN?this.eventEmitter.emit(F.OPEN):this.websocket.addEventListener("open",()=>{this.eventEmitter.emit(F.OPEN)}),this.websocket.addEventListener("message",e=>{try{const t=JSON.parse(e.data);switch(t.message_type){case"session_started":this.eventEmitter.emit(F.SESSION_STARTED,t);break;case"partial_transcript":this.eventEmitter.emit(F.PARTIAL_TRANSCRIPT,t);break;case"committed_transcript":this.eventEmitter.emit(F.COMMITTED_TRANSCRIPT,t);break;case"committed_transcript_with_timestamps":this.eventEmitter.emit(F.COMMITTED_TRANSCRIPT_WITH_TIMESTAMPS,t);break;case"auth_error":this.eventEmitter.emit(F.AUTH_ERROR,t);break;case"error":this.eventEmitter.emit(F.ERROR,t);break;default:console.warn("Unknown message type:",t)}}catch(t){console.error("Failed to parse WebSocket message:",t,e.data),this.eventEmitter.emit(F.ERROR,new Error(`Failed to parse message: ${t}`))}}),this.websocket.addEventListener("error",e=>{console.error("WebSocket error:",e),this.eventEmitter.emit(F.ERROR,e)}),this.websocket.addEventListener("close",e=>{if(console.log(`WebSocket closed: code=${e.code}, reason="${e.reason}", wasClean=${e.wasClean}`),!e.wasClean||1e3!==e.code&&1005!==e.code){const t=`WebSocket closed unexpectedly: ${e.code} - ${e.reason||"No reason provided"}`;console.error(t),this.eventEmitter.emit(F.ERROR,new Error(t))}this.eventEmitter.emit(F.CLOSE,e)})}on(e,t){this.eventEmitter.on(e,t)}off(e,t){this.eventEmitter.off(e,t)}send(e){var t,n;if(!this.websocket||this.websocket.readyState!==WebSocket.OPEN)throw new Error("WebSocket is not connected");const o={message_type:"input_audio_chunk",audio_base_64:e.audioBase64,commit:null!=(t=e.commit)&&t,sample_rate:null!=(n=e.sampleRate)?n:this.currentSampleRate};this.websocket.send(JSON.stringify(o))}commit(){if(!this.websocket||this.websocket.readyState!==WebSocket.OPEN)throw new Error("WebSocket is not connected");this.websocket.send(JSON.stringify({message_type:"input_audio_chunk",audio_base_64:"",commit:!0,sample_rate:this.currentSampleRate}))}close(){this._audioCleanup&&this._audioCleanup(),this.websocket&&this.websocket.close()}}const x=w("scribeAudioProcessor",'/*\n * Scribe Audio Processor for converting microphone audio to PCM16 format\n * USED BY @elevenlabs/client\n */\n\nclass ScribeAudioProcessor extends AudioWorkletProcessor {\n  constructor() {\n    super();\n    this.buffer = [];\n    this.bufferSize = 4096; // Buffer size for optimal chunk transmission\n  }\n\n  process(inputs) {\n    const input = inputs[0];\n    if (input.length > 0) {\n      const channelData = input[0]; // Get first channel (mono)\n\n      // Add incoming audio to buffer\n      this.buffer.push(...channelData);\n\n      // When buffer reaches threshold, convert and send\n      if (this.buffer.length >= this.bufferSize) {\n        const float32Array = new Float32Array(this.buffer);\n        const int16Array = new Int16Array(float32Array.length);\n\n        // Convert Float32 [-1, 1] to Int16 [-32768, 32767]\n        for (let i = 0; i < float32Array.length; i++) {\n          // Clamp the value to prevent overflow\n          const sample = Math.max(-1, Math.min(1, float32Array[i]));\n          // Scale to PCM16 range\n          int16Array[i] = sample < 0 ? sample * 32768 : sample * 32767;\n        }\n\n        // Send to main thread as transferable ArrayBuffer\n        this.port.postMessage(\n          {\n            audioData: int16Array.buffer\n          },\n          [int16Array.buffer]\n        );\n\n        // Clear buffer\n        this.buffer = [];\n      }\n    }\n\n    return true; // Continue processing\n  }\n}\n\nregisterProcessor("scribeAudioProcessor", ScribeAudioProcessor);\n\n');var O,L;!function(e){e.PCM_8000="pcm_8000",e.PCM_16000="pcm_16000",e.PCM_22050="pcm_22050",e.PCM_24000="pcm_24000",e.PCM_44100="pcm_44100",e.PCM_48000="pcm_48000",e.ULAW_8000="ulaw_8000"}(O||(O={})),function(e){e.MANUAL="manual",e.VAD="vad"}(L||(L={}));class U{static getWebSocketUri(e=U.DEFAULT_BASE_URI){return`${e}/v1/speech-to-text/realtime`}static buildWebSocketUri(e){const t=U.getWebSocketUri(e.baseUri),n=new URLSearchParams;if(n.append("model_id",e.modelId),n.append("token",e.token),void 0!==e.commitStrategy&&n.append("commit_strategy",e.commitStrategy),void 0!==e.vadSilenceThresholdSecs){if(e.vadSilenceThresholdSecs<=.3||e.vadSilenceThresholdSecs>3)throw new Error("vadSilenceThresholdSecs must be between 0.3 and 3.0");n.append("vad_silence_threshold_secs",e.vadSilenceThresholdSecs.toString())}if(void 0!==e.vadThreshold){if(e.vadThreshold<.1||e.vadThreshold>.9)throw new Error("vadThreshold must be between 0.1 and 0.9");n.append("vad_threshold",e.vadThreshold.toString())}if(void 0!==e.minSpeechDurationMs){if(e.minSpeechDurationMs<=50||e.minSpeechDurationMs>2e3)throw new Error("minSpeechDurationMs must be between 50 and 2000");n.append("min_speech_duration_ms",e.minSpeechDurationMs.toString())}if(void 0!==e.minSilenceDurationMs){if(e.minSilenceDurationMs<=50||e.minSilenceDurationMs>2e3)throw new Error("minSilenceDurationMs must be between 50 and 2000");n.append("min_silence_duration_ms",e.minSilenceDurationMs.toString())}void 0!==e.languageCode&&n.append("language_code",e.languageCode);const o=n.toString();return o?`${t}?${o}`:t}static connect(e){if(!e.modelId)throw new Error("modelId is required");const t=new R("microphone"in e&&e.microphone?16e3:e.sampleRate),n=U.buildWebSocketUri(e),o=new WebSocket(n);return"microphone"in e&&e.microphone&&o.addEventListener("open",()=>{U.streamFromMicrophone(e,t)}),t.setWebSocket(o),t}static async streamFromMicrophone(e,t){try{var n,o,a,s,i,r,c,l,u;const d=await navigator.mediaDevices.getUserMedia({audio:{deviceId:null==(n=e.microphone)?void 0:n.deviceId,echoCancellation:null==(o=null==(a=e.microphone)?void 0:a.echoCancellation)||o,noiseSuppression:null==(s=null==(i=e.microphone)?void 0:i.noiseSuppression)||s,autoGainControl:null==(r=null==(c=e.microphone)?void 0:c.autoGainControl)||r,channelCount:null!=(l=null==(u=e.microphone)?void 0:u.channelCount)?l:1,sampleRate:{ideal:16e3}}}),h=new AudioContext({sampleRate:16e3});await x(h.audioWorklet);const p=h.createMediaStreamSource(d),m=new AudioWorkletNode(h,"scribeAudioProcessor");m.port.onmessage=e=>{const{audioData:n}=e.data,o=new Uint8Array(n);let a="";for(let e=0;e<o.length;e++)a+=String.fromCharCode(o[e]);const s=btoa(a);t.send({audioBase64:s})},p.connect(m),"suspended"===h.state&&await h.resume(),t._audioCleanup=()=>{d.getTracks().forEach(e=>{e.stop()}),p.disconnect(),m.disconnect(),h.close()}}catch(e){throw console.error("Failed to start microphone streaming:",e),e}}}U.DEFAULT_BASE_URI="wss://api.elevenlabs.io";class W extends r{static startSession(e){return e.textOnly?C.startSession(e):D.startSession(e)}}export{O as AudioFormat,L as CommitStrategy,W as Conversation,E as Input,I as Output,R as RealtimeConnection,F as RealtimeEvents,U as Scribe,C as TextConversation,D as VoiceConversation,y as WebRTCConnection,m as WebSocketConnection,b as createConnection,T as postOverallFeedback};
//# sourceMappingURL=lib.modern.js.map
